from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup

class TheIndependent(BasicNewsRecipe):
    title          = u'The Independent'
    language       = 'en_GB'
    __author__     = 'Krittika Goyal'
    oldest_article = 2 #days
    max_articles_per_feed = 200
    summary_length         = 100
    encoding = 'latin1'

    no_stylesheets = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	              
					 
    #remove_tags_before = dict(name='h1', attrs={'class':'heading'})
    #remove_tags_after  = dict(name='td', attrs={'class':'newptool1'})
    remove_tags = [
       dict(name='iframe'),
       dict(name='div', attrs={'class':['related-articles','photoCaption','clear-o']}),
       dict(name='div', attrs={'id':['qrformdiv', 'inSection', 'alpha-inner']}),
       dict(name='ul', attrs={'class':'article-tools'}),
       dict(name='p', attrs={'class':'author'}),
       dict(name='img')
    ]

    feeds          = [
            ('World News',
            'http://www.independent.co.uk/news/world/rss'),
            ('UK News',
            'http://www.independent.co.uk/news/uk/home-news/rss'),
            ('People News',
            'http://www.independent.co.uk/news/people/news/rss'),
            ('People Profiles',
            'http://www.independent.co.uk/news/people/profiles/rss'),
            ('Science',
            'http://www.independent.co.uk/news/science/rss'),
            ('Music',
            'http://www.independent.co.uk/arts-entertainment/music/news/rss'),
            ('Premier League',
            'http://www.independent.co.uk/sport/football/premier-league/rss'),
            ('Football Comments',
            'http://www.independent.co.uk/sport/football/news-and-comment/rss'),
            ('Football European',
            'http://www.independent.co.uk/sport/football/european/rss'),
    ]

    def preprocess_html(self, soup):
        story = soup.find(name='div', attrs={'id':'mainColumn'})
        #td = heading.findParent(name='td')
        #td.extract()
        soup = BeautifulSoup('<html><head><title>t</title></head><body></body></html>')
        body = soup.find(name='body')
        body.insert(0, story)
        return soup

    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds